/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import android.util.Log;
import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.FT_EEPROM;

class FT_EE_Ctrl {
    private static final short EE_MAX_SIZE = 1024;
    private static final int PULL_DOWN_IN_USB_SUSPEND = 4;
    private static final int ENABLE_SERIAL_NUMBER = 8;
    private static final int SELF_POWERED = 64;
    private static final int BUS_POWERED = 128;
    private static final int USB_REMOTE_WAKEUP = 32;
    private FT_Device mDevice;
    short mEepromType;
    int mEepromSize;
    boolean mEepromBlank;

    FT_EE_Ctrl(FT_Device dev) {
        this.mDevice = dev;
    }

    int readWord(short offset) {
        byte[] dataRead = new byte[2];
        int rc = -1;
        if (offset >= 1024) {
            return rc;
        }
        short wIndex = offset;
        this.mDevice.getConnection().controlTransfer(-64, 144, 0, (int)wIndex, dataRead, 2, 0);
        int value = dataRead[1] & 0xFF;
        value <<= 8;
        return value |= dataRead[0] & 0xFF;
    }

    boolean writeWord(short offset, short value) {
        int wValue = value & 0xFFFF;
        int wIndex = offset & 0xFFFF;
        int status = 0;
        boolean rc = false;
        if (offset >= 1024) {
            return rc;
        }
        status = this.mDevice.getConnection().controlTransfer(64, 145, wValue, wIndex, null, 0, 0);
        if (status == 0) {
            rc = true;
        }
        return rc;
    }

    int eraseEeprom() {
        int status = 0;
        status = this.mDevice.getConnection().controlTransfer(64, 146, 0, 0, null, 0, 0);
        return status;
    }

    short programEeprom(FT_EEPROM eeprom) {
        return 1;
    }

    boolean programEeprom(int[] dataToWrite, int ee_size) {
        int checksumLocation = ee_size;
        int Checksum = 43690;
        int TempChecksum = 0;
        short a = 0;
        short b = 0;
        for (int addressCounter = 0; addressCounter < checksumLocation; ++addressCounter) {
            this.writeWord((short)addressCounter, (short)dataToWrite[addressCounter]);
            TempChecksum = dataToWrite[addressCounter] ^ Checksum;
            a = (short)((TempChecksum &= 0xFFFF) << 1 & 0xFFFF);
            b = (short)(TempChecksum >> 15 & 0xFFFF);
            Checksum = a | b;
            Log.d((String)"FT_EE_Ctrl", (String)("Entered WriteWord Checksum : " + (Checksum &= 0xFFFF)));
        }
        this.writeWord((short)checksumLocation, (short)Checksum);
        return true;
    }

    FT_EEPROM readEeprom() {
        return null;
    }

    int setUSBConfig(Object ee) {
        FT_EEPROM ft = (FT_EEPROM)ee;
        int word0x04 = 0;
        int lowerbits = 0;
        int upperbits = 0;
        lowerbits |= 0x80;
        if (ft.RemoteWakeup) {
            lowerbits |= 0x20;
        }
        if (ft.SelfPowered) {
            lowerbits |= 0x40;
        }
        upperbits = ft.MaxPower;
        upperbits /= 2;
        word0x04 = (upperbits <<= 8) | lowerbits;
        return word0x04;
    }

    void getUSBConfig(FT_EEPROM ee, int dataRead) {
        byte mP = (byte)(dataRead >> 8);
        ee.MaxPower = (short)(2 * mP);
        byte P = (byte)dataRead;
        ee.SelfPowered = (P & 0x40) == 64 && (P & 0x80) == 128;
        ee.RemoteWakeup = (P & 0x20) == 32;
    }

    int setDeviceControl(Object ee) {
        FT_EEPROM ft = (FT_EEPROM)ee;
        int data = 0;
        data = ft.PullDownEnable ? (data |= 4) : (data &= 0xFB);
        data = ft.SerNumEnable ? (data |= 8) : (data &= 0xF7);
        return data;
    }

    void getDeviceControl(Object ee, int dataRead) {
        FT_EEPROM ft = (FT_EEPROM)ee;
        ft.PullDownEnable = (dataRead & 4) > 0;
        ft.SerNumEnable = (dataRead & 8) > 0;
    }

    int setStringDescriptor(String s, int[] data, int addrs, int pointer, boolean rdevice) {
        int i = 0;
        int strLength = s.length() * 2 + 2;
        data[pointer] = strLength << 8 | addrs * 2;
        if (rdevice) {
            int n = pointer;
            data[n] = data[n] + 128;
        }
        char[] strchar = s.toCharArray();
        data[addrs++] = strLength | 0x300;
        strLength -= 2;
        strLength /= 2;
        do {
            data[addrs++] = strchar[i];
        } while (++i < strLength);
        return addrs;
    }

    String getStringDescriptor(int addr, int[] dataRead) {
        String descriptor = "";
        int len = dataRead[addr] & 0xFF;
        len = len / 2 - 1;
        int endaddr = ++addr + len;
        for (int i = addr; i < endaddr; ++i) {
            descriptor = descriptor + (char)dataRead[i];
        }
        return descriptor;
    }

    void clearUserDataArea(int saddr, int eeprom_size, int[] data) {
        while (saddr < eeprom_size) {
            data[saddr++] = 0;
        }
    }

    int getEepromSize(byte location) throws D2xxManager.D2xxException {
        int data = 192;
        int wordRead = 0;
        short eeData = 0;
        short address = (short)(location & 0xFFFFFFFF);
        int[] dataRead = new int[3];
        boolean rc = false;
        eeData = (short)this.readWord(address);
        if (eeData != 65535) {
            switch (eeData) {
                case 70: {
                    this.mEepromType = (short)70;
                    this.mEepromSize = 64;
                    this.mEepromBlank = false;
                    return 64;
                }
                case 86: {
                    this.mEepromType = (short)86;
                    this.mEepromSize = 128;
                    this.mEepromBlank = false;
                    return 128;
                }
                case 102: {
                    this.mEepromType = (short)102;
                    this.mEepromSize = 128;
                    this.mEepromBlank = false;
                    return 256;
                }
                case 82: {
                    this.mEepromType = (short)82;
                    this.mEepromSize = 1024;
                    this.mEepromBlank = false;
                    return 1024;
                }
            }
            return 0;
        }
        address = 192;
        rc = this.writeWord(address, (short)data);
        dataRead[0] = this.readWord((short)192);
        dataRead[1] = this.readWord((short)64);
        dataRead[2] = this.readWord((short)0);
        if (!rc) {
            this.mEepromType = (short)255;
            this.mEepromSize = 0;
            return 0;
        }
        this.mEepromBlank = true;
        address = 0;
        wordRead = this.readWord(address);
        if ((wordRead & 0xFF) == 192) {
            this.eraseEeprom();
            this.mEepromType = (short)70;
            this.mEepromSize = 64;
            return 64;
        }
        address = 64;
        wordRead = this.readWord(address);
        if ((wordRead & 0xFF) == 192) {
            this.eraseEeprom();
            this.mEepromType = (short)86;
            this.mEepromSize = 128;
            return 128;
        }
        address = 192;
        wordRead = this.readWord(address);
        if ((wordRead & 0xFF) == 192) {
            this.eraseEeprom();
            this.mEepromType = (short)102;
            this.mEepromSize = 128;
            return 256;
        }
        this.eraseEeprom();
        return 0;
    }

    int writeUserData(byte[] data) {
        return 0;
    }

    byte[] readUserData(int length) {
        return null;
    }

    int getUserSize() {
        return 0;
    }

    static final class EepromType {
        static final short TYPE_46 = 70;
        static final short TYPE_52 = 82;
        static final short TYPE_56 = 86;
        static final short TYPE_66 = 102;
        static final short TYPE_MTP = 1;
        static final short INVALID = 255;

        EepromType() {
        }
    }
}

